/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3533;
import net.minecraft.class_4706;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5577;
import net.minecraft.class_5579;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.example.ExampleGuiPortalRendering;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.chunk_loading.PlayerChunkLoading;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IEDistanceManager;
import qouteall.imm_ptl.core.ducks.IEServerChunkCache;
import qouteall.imm_ptl.core.ducks.IEServerWorld;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEChunkMap_Accessor;
import qouteall.imm_ptl.core.mixin.common.mc_util.IELevelEntityGetterAdapter;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;

public class PortalDebugCommands {
    private static final Logger LOGGER = LogUtils.getLogger();

    static void registerDebugCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"gui_portal").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> {
            ExampleGuiPortalRendering.onCommandExecuted(((class_2168)context.getSource()).method_9207(), class_2181.method_9289((CommandContext)context, (String)"dim"), class_2277.method_9736((CommandContext)context, (String)"pos"));
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"isometric_enable").then(class_2170.method_9244((String)"viewLength", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            float viewLength = FloatArgumentType.getFloat((CommandContext)context, (String)"viewLength");
            Validate.isTrue(((double)Math.abs(viewLength) > 0.1 ? 1 : 0) != 0);
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.enableIsometricView", Float.valueOf(viewLength));
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"isometric_disable").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.disableIsometricView", new Object[0]);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"align").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_243 pos = player.method_19538();
            class_243 newPos = new class_243((double)Math.round(pos.field_1352 * 2.0) / 2.0, (double)Math.round(pos.field_1351 * 2.0) / 2.0, (double)Math.round(pos.field_1350 * 2.0) / 2.0);
            player.field_13987.method_14363(newPos.field_1352, newPos.field_1351, newPos.field_1350, 45.0f, 30.0f);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"profile").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_lag_logging_threshold").requires(serverCommandSource -> serverCommandSource.method_9259(4))).then(class_2170.method_9244((String)"ms", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int ms = IntegerArgumentType.getInteger((CommandContext)context, (String)"ms");
            class_3533.field_16267 = Duration.ofMillis(ms).toNanos();
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gc").requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(context -> {
            System.gc();
            long l = Runtime.getRuntime().maxMemory();
            long m = Runtime.getRuntime().totalMemory();
            long n = Runtime.getRuntime().freeMemory();
            long o = m - n;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Memory: % 2d%% %03d/%03dMB", o * 100L / l, PortalDebugCommands.toMiB(o), PortalDebugCommands.toMiB(l))), false);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).executes(context -> {
            PortalCommand.createCommandStickCommandSignal.emit(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"command"));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"accelerate").requires(PortalCommand::canUsePortalCommand)).then(class_2170.method_9244((String)"v", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            double v = DoubleArgumentType.getDouble((CommandContext)context, (String)"v");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_243 vec = player.method_5828(1.0f).method_1021(v / 20.0);
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"accelerate_along").requires(PortalCommand::canUsePortalCommand)).then(class_2170.method_9244((String)"vec", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> {
            class_243 vec = class_2277.method_9736((CommandContext)context, (String)"vec");
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec.method_1021(0.05));
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"test").executes(context -> 0));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"erase_chunk").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rChunks", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)player.method_19538()));
            PortalDebugCommands.invokeEraseChunk(player.method_37908(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), McHelper.getMinY((class_1936)player.method_37908()), McHelper.getMaxYExclusive((class_1936)player.method_37908()));
            return 0;
        })).then(class_2170.method_9244((String)"downY", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"upY", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)player.method_19538()));
            PortalDebugCommands.invokeEraseChunk(player.method_37908(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), IntegerArgumentType.getInteger((CommandContext)context, (String)"downY"), IntegerArgumentType.getInteger((CommandContext)context, (String)"upY"));
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_chunk_loaders").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ChunkVisibility.foreachBaseChunkLoaders(player, loader -> McHelper.serverLog(player, loader.toString()));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_server_entities_nearby").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            List entities = player.method_37908().method_8390(class_1297.class, new class_238(player.method_19538(), player.method_19538()).method_1014(32.0), e -> true);
            McHelper.serverLog(player, entities.stream().map(class_1297::toString).collect(Collectors.joining("\n")));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_loaded_portals").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            MinecraftServer server = source.method_9211();
            for (class_3218 world : server.method_3738()) {
                for (class_1297 entity : world.method_27909()) {
                    if (!(entity instanceof Portal)) continue;
                    Portal portal = (Portal)entity;
                    source.method_9226(() -> class_2561.method_43470((String)entity.toString()), true);
                }
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"is_chunk_loaded").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int chunkX = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX");
            int chunkZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ");
            class_3218 world = class_2181.method_9289((CommandContext)context, (String)"dim");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PortalDebugCommands.doReportChunkStatus(chunkX, chunkZ, world, player);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_chunk_at").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3218 world = class_2181.method_9289((CommandContext)context, (String)"dim");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            class_1923 chunkPos = new class_1923(pos);
            PortalDebugCommands.doReportChunkStatus(chunkPos.field_9181, chunkPos.field_9180, world, player);
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"report_player_status").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CHelper.printChat(String.format("On Server %s %s removal:%s added:%s age:%s", player.method_37908().method_27983().method_29177(), player.method_24515(), player.method_35049(), player.method_37908().method_8469(player.method_5628()) != null, player.field_6012));
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientPlayerStatus", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list_portals").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            StringBuilder result = new StringBuilder();
            result.append("Server Portals\n");
            for (class_3218 world : MiscHelper.getServer().method_3738()) {
                result.append(world.method_27983().method_29177().toString() + "\n");
                for (class_1297 entity : world.method_27909()) {
                    for (class_1297 e : world.method_27909()) {
                        if (!(e instanceof Portal)) continue;
                        result.append(e.toString());
                        result.append("\n");
                    }
                }
            }
            McHelper.serverLog(player, result.toString());
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.doListPortals", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_resource_consumption").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> {
            StringBuilder str = new StringBuilder();
            str.append("Server Tracked Chunks:\n");
            MiscHelper.getServer().method_3738().forEach(world -> str.append(PortalDebugCommands.getServerWorldResourceConsumption(world)));
            McHelper.serverLog(((class_2168)context.getSource()).method_9207(), str.toString());
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportResourceConsumption", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_chunk_ticket_stat").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            Iterable<class_3193> chunkHolders = ((IEChunkMap_Accessor)world.method_14178().field_17254).ip_getChunks();
            Object2IntOpenHashMap stat = new Object2IntOpenHashMap();
            for (class_3193 chunkHolder : chunkHolders) {
                long chunkPos = chunkHolder.method_60473().method_8324();
                class_4706<class_3228<?>> chunkTickets = ((IEDistanceManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(chunkPos);
                for (class_3228 ticket : chunkTickets) {
                    stat.addTo((Object)ticket.method_14281(), 1);
                }
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
            for (Object2IntMap.Entry entry : stat.object2IntEntrySet()) {
                class_3230 ticketType = (class_3230)entry.getKey();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(ticketType.toString() + " " + entry.getIntValue())), false);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report_per_player_chunk_loading").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> {
            List players = MiscHelper.getServer().method_3760().method_14571();
            for (class_3222 player : players) {
                PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
                String text = "%s %d".formatted(player.method_5477().getString(), playerInfo.loadedChunks);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)text), true);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save_all_chunks").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            server.method_3723(true, true, false);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"simplify_portal_mesh").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalShape portalShape = portal.getPortalShape();
            if (portalShape instanceof SpecialFlatPortalShape) {
                SpecialFlatPortalShape s = (SpecialFlatPortalShape)portalShape;
                s.mesh.simplifySteps(1);
                portal.reloadPortal();
            }
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"check_biome_registry").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> {
            class_5455.class_6890 registryAccess = MiscHelper.getServer().method_30611();
            class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Map.Entry entry : biomes.method_29722()) {
                String strId = ((class_5321)entry.getKey()).method_29177().toString();
                int intId = biomes.method_10206((Object)((class_1959)entry.getValue()));
                map.put(strId, intId);
            }
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.ClientWorldLoader.RemoteCallables.checkBiomeRegistry", map);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"nofog_enable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", true);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"nofog_disable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", false);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"report_air").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_2680 blockState = player.method_37908().method_8320(player.method_24515());
            ((class_2168)context.getSource()).method_9226(() -> blockState.method_26204().method_9518(), false);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"test_invalid_rpc").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((class_2168)context.getSource()).method_9207(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.testInvalidRPC", new Object[0]);
            return 0;
        }));
    }

    private static void doReportChunkStatus(int chunkX, int chunkZ, class_3218 world, class_3222 player) {
        class_2818 chunk = McHelper.getServerChunkIfPresent(world, chunkX, chunkZ);
        boolean loaded = chunk != null && !(chunk instanceof class_2812);
        long longChunkPos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        if (loaded) {
            boolean shouldTickEntities = ImmPtlChunkTickets.getDistanceManager(world).method_38630(longChunkPos);
            if (shouldTickEntities) {
                McHelper.serverLog(player, "Server chunk loaded and entity tickable");
            } else {
                McHelper.serverLog(player, "Server chunk loaded but entity not tickable");
            }
        } else {
            McHelper.serverLog(player, "Server chunk not loaded");
        }
        class_3193 chunkHolder = McHelper.getIEChunkMap((class_5321<class_1937>)world.method_27983()).ip_getChunkHolder(longChunkPos);
        if (chunkHolder == null) {
            McHelper.serverLog(player, "no chunk holder");
        } else {
            McHelper.serverLog(player, String.format("chunk holder level:%s %s", chunkHolder.method_14005(), chunk == null ? "" : chunk.method_12225()));
            class_3204 distanceManager = ((IEServerChunkCache)world.method_14178()).ip_getDistanceManager();
            class_4706<class_3228<?>> tickets = ((IEDistanceManager)distanceManager).portal_getTicketSet(longChunkPos);
            for (class_3228 ticket : tickets) {
                McHelper.serverLog(player, ticket.toString());
            }
        }
        McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientChunkLoadStatus", world.method_27983(), chunkX, chunkZ);
    }

    public static String getServerWorldResourceConsumption(class_3218 world) {
        StringBuilder subStr = new StringBuilder();
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        class_5577<class_1297> entityLookup = ((IEWorld)world).portal_getEntityLookup();
        subStr.append(String.format("%s:\nImmPtl Tracked Chunks: %s\nImmPtl Loading Ticket:%s\nChunks: %s\nEntities:%s Entity Sections:%s\n", world.method_27983().method_29177(), ImmPtlChunkTracking.getLoadedChunkNum((class_5321<class_1937>)world.method_27983()), dimTicketManager.getLoadedChunkNum(), world.method_14178().field_17254.method_17260(), ((IELevelEntityGetterAdapter)entityLookup).getIndex().method_31756(), ((IELevelEntityGetterAdapter)entityLookup).getCache().method_31781()));
        class_5579<class_1297> entityManager = ((IEServerWorld)world).ip_getEntityManager();
        entityManager.method_31836();
        subStr.append(String.format("Entity Manager: %s\n", entityManager.method_31845()));
        subStr.append("\n");
        String result = subStr.toString();
        return result;
    }

    public static long toMiB(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static void invokeEraseChunk(class_1937 world, class_1923 center, int r, int downY, int upY) {
        ArrayList<class_1923> poses = new ArrayList<class_1923>();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                poses.add(new class_1923(x + center.field_9181, z + center.field_9180));
            }
        }
        poses.sort(Comparator.comparingDouble(c -> class_243.method_24954((class_2382)center.method_8323()).method_1022(class_243.method_24954((class_2382)c.method_8323()))));
        ServerTaskList.of(world.method_8503()).addTask(MyTaskList.chainTasks(poses.stream().map(chunkPos -> () -> {
            PortalDebugCommands.eraseChunk(chunkPos, world, downY, upY);
            return true;
        }).iterator()));
    }

    public static void eraseChunk(class_1923 chunkPos, class_1937 world, int yStart, int yEnd) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = yStart; y < yEnd; ++y) {
                    world.method_8501(new class_2338(chunkPos.method_8326() + x, y, chunkPos.method_8328() + z), class_2246.field_10124.method_9564());
                }
            }
        }
    }
}

